/* Resenje: Viktor Radovic */

#include <iostream>
using namespace std;

template <class T> 
class Niz
{
private:
	unsigned _duzina;
	unsigned _obezbedjeno;
	T* _elementi;

	void povecanjeNiza(unsigned n)
	{
		if(n<=_duzina)
			return;
		if(n>_obezbedjeno)
		{
			  unsigned ob=n;
			  if(_duzina*2>ob) ob=_duzina*2;
			  T* novi= new T[ob];
			  for(unsigned i=0;i<_duzina;i++)
                  novi[i]=_elementi[i];
			  delete [] _elementi;
			  _elementi=novi;
			  _obezbedjeno= ob;
		}
		for(unsigned i=_duzina;i<n;i++)
			   _elementi[i]=0;
		_duzina=n;
	}

public:
	Niz() : _duzina(0),_obezbedjeno(0),_elementi(0)
	{}
	~Niz() {
		  delete [] _elementi;
		  }

	Niz(const Niz<T>& n) : _duzina(n._duzina),_obezbedjeno(n._duzina),_elementi(n._duzina>0 ?  new T[n._duzina] : 0)
	{
		for (unsigned i=0;i<_duzina;i++)
			_elementi[i]=n._elementi[i];
	}

	Niz<T>& operator = (const Niz<T>& n)
	{
		if(this != &n)
		{
			delete [] _elementi;
			_duzina=n._duzina;
			_obezbedjeno=n._duzina;
			_elementi=n._duzina>0 ? new T[n._duzina] : 0;
			for(unsigned i=0;i<_duzina;i++)
				   _elementi[i]=n._elementi[i];
		}
		return *this;
	}

	void ispis(ostream& ostr) const
	{
		ostr<< '[' << _duzina << ':';
		for(unsigned i=0;i<_duzina;i++)
			ostr<<_elementi[i]<<',';
		ostr<< "\b]";
	}
	T& operator [] (unsigned i)
	{
		if(i>=_duzina)
			povecanjeNiza(i+1);
		return _elementi[i];
	}

	unsigned Duzina() const
	{
		  return _duzina;
	}
};

template <class T>
ostream& operator << (ostream& ostr, const Niz<T>& n )
{
n.ispis(ostr);
return ostr;
}


main()
{	
	Niz<int> a;
	a[4]=3.6;
	a[2]=2;

	Niz<int> b(a);
	b[3]=7;
	b[5]=8;

	cout << "a:"<< a <<endl;
	cout << "b:"<< b <<endl;

	a[7]=2;
	cout << "a:"<< a <<endl;

	Niz<double> c;
	c[15] = 15.0;
	c[16] = 16.0;
	cout << "c:" << c << endl;

	return 0;
}


